# 🚀 Quick Reference - Laravel Artisan Commands

## 📦 Database Commands

```bash
# Jalankan migration
php artisan migrate

# Rollback migration terakhir
php artisan migrate:rollback

# Rollback semua migration
php artisan migrate:reset

# Refresh database (drop all tables & re-migrate)
php artisan migrate:refresh

# Fresh migration (drop all tables & re-migrate)
php artisan migrate:fresh

# Fresh migration dengan seeder
php artisan migrate:fresh --seed

# Lihat status migration
php artisan migrate:status

# Jalankan seeder
php artisan db:seed

# Jalankan seeder tertentu
php artisan db:seed --class=UserSeeder

# Lihat informasi database
php artisan db:show

# Lihat struktur tabel
php artisan db:table users
```

## 🏗️ Make Commands (Generate Files)

```bash
# Membuat Model
php artisan make:model Product

# Membuat Model dengan Migration
php artisan make:model Product -m

# Membuat Model dengan Migration, Factory, dan Seeder
php artisan make:model Product -mfs

# Membuat Model dengan semua (Migration, Factory, Seeder, Controller)
php artisan make:model Product -a

# Membuat Controller
php artisan make:controller ProductController

# Membuat Resource Controller
php artisan make:controller ProductController --resource

# Membuat API Controller
php artisan make:controller API/ProductController --api

# Membuat Migration
php artisan make:migration create_products_table

# Membuat Migration untuk alter table
php artisan make:migration add_price_to_products_table

# Membuat Seeder
php artisan make:seeder ProductSeeder

# Membuat Factory
php artisan make:factory ProductFactory

# Membuat Request (Form Request Validation)
php artisan make:request StoreProductRequest

# Membuat Middleware
php artisan make:middleware CheckAge

# Membuat Policy
php artisan make:policy ProductPolicy

# Membuat Event
php artisan make:event OrderShipped

# Membuat Listener
php artisan make:listener SendShipmentNotification

# Membuat Job
php artisan make:job ProcessPayment

# Membuat Mail
php artisan make:mail OrderShipped

# Membuat Notification
php artisan make:notification InvoicePaid

# Membuat Command
php artisan make:command SendEmails
```

## 🔧 Cache Commands

```bash
# Clear application cache
php artisan cache:clear

# Clear config cache
php artisan config:clear

# Clear route cache
php artisan route:clear

# Clear view cache
php artisan view:clear

# Clear compiled class file
php artisan clear-compiled

# Clear all cache sekaligus
php artisan optimize:clear

# Cache config
php artisan config:cache

# Cache routes
php artisan route:cache

# Cache views
php artisan view:cache

# Optimize aplikasi (cache config, routes, views)
php artisan optimize
```

## 🌐 Server & Development

```bash
# Jalankan development server
php artisan serve

# Jalankan di port custom
php artisan serve --port=8080

# Jalankan di host custom
php artisan serve --host=192.168.1.100

# Jalankan di port dan host custom
php artisan serve --host=0.0.0.0 --port=8000

# Generate application key
php artisan key:generate

# Masuk ke Tinker (REPL)
php artisan tinker

# Lihat daftar routes
php artisan route:list

# Lihat routes tertentu
php artisan route:list --path=api

# Lihat routes dengan method tertentu
php artisan route:list --method=GET
```

## 📁 Storage Commands

```bash
# Buat symbolic link storage
php artisan storage:link

# Clear storage logs
php artisan storage:clear
```

## 🔐 Authentication

```bash
# Install Laravel Breeze (Authentication Scaffolding)
composer require laravel/breeze --dev
php artisan breeze:install

# Install Laravel UI (Alternative)
composer require laravel/ui
php artisan ui bootstrap --auth
php artisan ui vue --auth
php artisan ui react --auth
```

## 📊 Queue Commands

```bash
# Jalankan queue worker
php artisan queue:work

# Jalankan queue worker untuk connection tertentu
php artisan queue:work redis

# Jalankan queue worker untuk queue tertentu
php artisan queue:work --queue=emails

# Jalankan queue listener
php artisan queue:listen

# Restart queue workers
php artisan queue:restart

# Retry failed jobs
php artisan queue:retry all

# Lihat failed jobs
php artisan queue:failed

# Clear failed jobs
php artisan queue:flush
```

## 🧪 Testing

```bash
# Jalankan semua tests
php artisan test

# Jalankan test tertentu
php artisan test --filter=UserTest

# Jalankan test dengan coverage
php artisan test --coverage

# Membuat test
php artisan make:test UserTest

# Membuat unit test
php artisan make:test UserTest --unit
```

## 📝 Maintenance Mode

```bash
# Aktifkan maintenance mode
php artisan down

# Aktifkan dengan secret bypass
php artisan down --secret="1630542a-246b-4b66-afa1-dd72a4c43515"

# Aktifkan dengan custom message
php artisan down --message="Sedang maintenance, mohon tunggu"

# Nonaktifkan maintenance mode
php artisan up
```

## 🔍 Debugging & Information

```bash
# Lihat versi Laravel
php artisan --version

# Lihat environment
php artisan env

# Lihat semua artisan commands
php artisan list

# Lihat help untuk command tertentu
php artisan help migrate

# Lihat informasi aplikasi
php artisan about

# Lihat event listeners
php artisan event:list

# Lihat scheduled tasks
php artisan schedule:list
```

## 🗂️ Vendor Publishing

```bash
# Publish semua vendor assets
php artisan vendor:publish

# Publish vendor tertentu
php artisan vendor:publish --provider="Vendor\Package\ServiceProvider"

# Publish tag tertentu
php artisan vendor:publish --tag=public
```

## 💡 Tips & Tricks

```bash
# Kombinasi commands dengan &&
php artisan migrate:fresh && php artisan db:seed

# Jalankan migration di environment tertentu
php artisan migrate --env=production

# Force migration (tanpa konfirmasi di production)
php artisan migrate --force

# Pretend migration (lihat SQL tanpa execute)
php artisan migrate --pretend

# Seed database tertentu
php artisan db:seed --database=mysql

# Optimize untuk production
php artisan config:cache && php artisan route:cache && php artisan view:cache

# Clear semua cache
php artisan optimize:clear && php artisan cache:clear
```

## 🎯 Development Workflow

```bash
# 1. Setup project baru
composer install
cp .env.example .env
php artisan key:generate
php artisan migrate

# 2. Daily development
php artisan serve
php artisan migrate
php artisan db:seed

# 3. Sebelum commit
php artisan test
php artisan optimize:clear

# 4. Deploy ke production
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan migrate --force
```

---

**Pro Tip**: Gunakan `php artisan` untuk melihat semua available commands!
