<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LinkCreatedNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $shortlink;

    /**
     * Create a new notification instance.
     */
    public function __construct($shortlink)
    {
        $this->shortlink = $shortlink;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $name = $this->shortlink->title ?: ($this->shortlink->custom_alias ?: $this->shortlink->short_code);
        return [
            'title' => 'Link Baru',
            'message' => "Link baru dengan nama \"{$name}\" berhasil dibuat.",
            'link_id' => $this->shortlink->id,
            'icon' => 'fa-plus',
            'color' => 'text-emerald-500 bg-emerald-50',
            'link' => route('shortlinks.index', ['search' => $this->shortlink->short_code])
        ];
    }
}
